<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Landn Kitchen | Receipt</title>

    <!-- Google Font: Source Sans Pro -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="{https://use.fontawesome.com/releases/v5.8.1/css/all.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.0/css/bootstrap.min.css">

    <style>
        .body-main {
            background: #ffffff;
            border-bottom: 15px solid #1E1F23;
            border-top: 15px solid #1E1F23;
            margin-top: 30px;
            margin-bottom: 30px;
            padding: 40px 30px !important;
            position: relative;
            box-shadow: 0 1px 21px #808080;
            font-size: 10px
        }

        .main thead {
            background: #1E1F23;
            color: #fff
        }

        .img {
            height: 100px
        }

        h1 {
            text-align: center
        }
                table {
        border-collapse: collapse;
        border-spacing: 0;
        text-align: center;
    }

    .table>thead>tr>th {
        vertical-align: bottom;
        border-bottom: 2px solid #dddddd;
    }

    .table>thead>tr>th,
    .table>tbody>tr>th,
    .table>tfoot>tr>th,
    .table>thead>tr>td,
    .table>tbody>tr>td,
    .table>tfoot>tr>td {
        padding: 5px;
        line-height: 1.42857143;
        vertical-align: top;
        border-top: 1px solid #F0F0F0;
        border: 1px solid black;
        text-align: center;
    }

    .xcrud-th th {

        background: #efefef;
        white-space: nowrap;
        font-size: 12px;
        font-weight: bold;

    }

    th {
        text-align: left;
    }

    .btn-warning {
        color: #ffffff;
        background-color: #fbb450;
        border-color: #faa937;
    }

    .btn-xcrud,
    .btn-group-sm>.btn {

        padding: 0px 5px;
        font-size: 12px;
        line-height: 1.5;
        -webkit-border-radius: 0;
        border-radius: 0;

    }

    .btn-danger {

        color: #ffffff;
        background-color: #ee5f5b;
        border-color: #ec4844;

    }

    .btn-warning {

        color: #ffffff;
        background-color: #fbb450;
        border-color: #faa937;

    }

    .btn-danger {

        color: #ffffff;
        background-color: #ee5f5b;
        border-color: #ec4844;

    }

    .pull-left {
        padding-right: 3px;
    }

    .table {
        width: 100%;
        margin-bottom: 1rem;
        background-color: transparent
    }

    .table td,
    .table th {
        padding: .75rem;
        vertical-align: top;
        border-top: 1px solid #dee2e6
    }

    .table thead th {
        vertical-align: bottom;
        border-bottom: 2px solid #dee2e6
    }

    .table tbody+tbody {
        border-top: 2px solid #dee2e6
    }

    .table .table {
        background-color: #f8fafc
    }

    .table-sm td,
    .table-sm th {
        padding: .3rem
    }

    .table-bordered,
    .table-bordered td,
    .table-bordered th {
        border: 1px solid #dee2e6
    }

    .table-bordered thead td,
    .table-bordered thead th {
        border-bottom-width: 2px
    }

    .table-borderless tbody+tbody,
    .table-borderless td,
    .table-borderless th,
    .table-borderless thead th {
        border: 0
    }

    .table-striped tbody tr:nth-of-type(odd) {
        background-color: rgba(0, 0, 0, .05)
    }

    .table-hover tbody tr:hover {
        background-color: rgba(0, 0, 0, .075)
    }

    .table-primary,
    .table-primary>td,
    .table-primary>th {
        background-color: #c6e0f5
    }

    .table-hover .table-primary:hover,
    .table-hover .table-primary:hover>td,
    .table-hover .table-primary:hover>th {
        background-color: #b0d4f1
    }

    .table-secondary,
    .table-secondary>td,
    .table-secondary>th {
        background-color: #d6d8db
    }

    .table-hover .table-secondary:hover,
    .table-hover .table-secondary:hover>td,
    .table-hover .table-secondary:hover>th {
        background-color: #c8cbcf
    }

    .table-success,
    .table-success>td,
    .table-success>th {
        background-color: #c7eed8
    }

    .table-hover .table-success:hover,
    .table-hover .table-success:hover>td,
    .table-hover .table-success:hover>th {
        background-color: #b3e8ca
    }

    .table-info,
    .table-info>td,
    .table-info>th {
        background-color: #d6e9f9
    }

    .table-hover .table-info:hover,
    .table-hover .table-info:hover>td,
    .table-hover .table-info:hover>th {
        background-color: #c0ddf6
    }

    .table-warning,
    .table-warning>td,
    .table-warning>th {
        background-color: #fffacc
    }

    .table-hover .table-warning:hover,
    .table-hover .table-warning:hover>td,
    .table-hover .table-warning:hover>th {
        background-color: #fff8b3
    }

    .table-danger,
    .table-danger>td,
    .table-danger>th {
        background-color: #f7c6c5
    }

    .table-hover .table-danger:hover,
    .table-hover .table-danger:hover>td,
    .table-hover .table-danger:hover>th {
        background-color: #f4b0af
    }

    .table-light,
    .table-light>td,
    .table-light>th {
        background-color: #fdfdfe
    }

    .table-hover .table-light:hover,
    .table-hover .table-light:hover>td,
    .table-hover .table-light:hover>th {
        background-color: #ececf6
    }

    .table-dark,
    .table-dark>td,
    .table-dark>th {
        background-color: #c6c8ca
    }

    .table-hover .table-dark:hover,
    .table-hover .table-dark:hover>td,
    .table-hover .table-dark:hover>th {
        background-color: #b9bbbe
    }

    .table-active,
    .table-active>td,
    .table-active>th,
    .table-hover .table-active:hover,
    .table-hover .table-active:hover>td,
    .table-hover .table-active:hover>th {
        background-color: rgba(0, 0, 0, .075)
    }

    .table .thead-dark th {
        color: #f8fafc;
        background-color: #212529;
        border-color: #32383e
    }

    .table .thead-light th {
        color: #495057;
        background-color: #e9ecef;
        border-color: #dee2e6
    }

    .table-dark {
        color: #f8fafc;
        background-color: #212529
    }

    .table-dark td,
    .table-dark th,
    .table-dark thead th {
        border-color: #32383e
    }

    .table-dark.table-bordered {
        border: 0
    }

    .table-dark.table-striped tbody tr:nth-of-type(odd) {
        background-color: hsla(0, 0%, 100%, .05)
    }

    .table-dark.table-hover tbody tr:hover {
        background-color: hsla(0, 0%, 100%, .075)
    }

    @media (max-width:575.98px) {
        .table-responsive-sm {
            display: block;
            width: 100%;
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
            -ms-overflow-style: -ms-autohiding-scrollbar
        }

        .table-responsive-sm>.table-bordered {
            border: 0
        }
    }

    @media (max-width:767.98px) {
        .table-responsive-md {
            display: block;
            width: 100%;
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
            -ms-overflow-style: -ms-autohiding-scrollbar
        }

        .table-responsive-md>.table-bordered {
            border: 0
        }
    }

    @media (max-width:991.98px) {
        .table-responsive-lg {
            display: block;
            width: 100%;
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
            -ms-overflow-style: -ms-autohiding-scrollbar
        }

        .table-responsive-lg>.table-bordered {
            border: 0
        }
    }

    @media (max-width:1199.98px) {
        .table-responsive-xl {
            display: block;
            width: 100%;
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
            -ms-overflow-style: -ms-autohiding-scrollbar
        }

        .table-responsive-xl>.table-bordered {
            border: 0
        }
    }

    .table-responsive {
        display: block;
        width: 100%;
        overflow-x: auto;
        -webkit-overflow-scrolling: touch;
        -ms-overflow-style: -ms-autohiding-scrollbar
    }

    .table-responsive>.table-bordered {
        border: 0
    }
    </style>
</head>
<body>

<div class="container">
    <div class="page-header">
        <h1>Payment Receipt </h1>
    </div>
    <div class="container">
        <div class="row">
            <div class="col-md-6 col-md-offset-3 body-main">
                <div class="col-md-12">
                    <center>
                        <img class="img" alt="Logo" src="<?php echo e(asset('img/logo/logo_black.png')); ?>" />
                    </center>
                <br>
                <br>
                    <div>
                        <center>
                        <div class="col-md-12 text-center" style"text-align: center">
                            <h2>Payment Receipt</h2>
                            <h5>Reference: <?php echo e($data['reference']); ?></h5>
                        </div>
                        </center>
                        <table class="table table-bordered table-striped">
                            <tbody>
                                <tr>
                                <td class="col-md-9">Name</td>
                                <td class="col-md-3"><?php echo e($data['metadata']['name']); ?></td>
                            </tr>
                            <tr>
                                <td class="col-md-9">Paid On</td>
                                <td class="col-md-3"><?php echo e(Carbon\Carbon::parse($data['paid_at'])->format('d F, Y h:ia')); ?></td>
                            </tr>
                            <tr>
                                <td class="col-md-9">Transaction Amount</td>
                                <td class="col-md-3">&#x20A6; <?php echo e(number_format($data['amount']/100, 2)); ?> </td>
                            </tr>
                            <tr>
                                <td class="col-md-9">Payment Method</td>
                                <td class="col-md-3">Paystack</td>
                            </tr>
                            <tr>
                                <td class="col-md-9">Fee</td>
                                <td class="col-md-3">&#x20A6; <?php echo e(number_format($data['fees']/100, 2)); ?> </td>
                            </tr>
                            <tr>
                                <td class="col-md-9">Description</td>
                                <td class="col-md-3">Food Order</td>
                            </tr>
                            <tr>
                                <td class="text-right">
                                    <p> <strong>Total Amount: </strong> </p>
                                    <p> <strong>Discount: </strong> </p>
                                </td>
                                <td>
                                    <p> <strong>&#x20A6; <?php echo e(number_format($data['amount']/100, 2)); ?> </strong> </p>
                                    <p> <strong>&#x20A6; 0 </strong> </p>
                                </td>
                            </tr>
                            <tr style="color: #F81D2D;">
                                <td class="text-right">
                                    <h4><strong>Total:</strong></h4>
                                </td>
                                <td class="text-left">
                                    <h4><strong>&#x20A6; <?php echo e(number_format($data['amount']/100, 2)); ?> </strong></h4>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                    <div>
                        <div class="col-md-12">
                            <p><b>Date :</b><br> <?php echo e(Carbon\Carbon::parse($data['created_at'])->format('d F, Y h:ia')); ?></p> <br />
                            <p><b>Signature</b><br> <i><small>LandN Kitchen Restaurant</small></i></p>
                        </div>

                    <br>
                    <br>
                    <hr>
                    <br>
                    <div style="text-align: center">
                            <h4 style="color: #F81D2D;"><strong>LandN Kitchen Restaurant</strong></h4>
                            <p>1st Avenue, beside Total Filling Station,</p>
                            <p> Gwarinpa Estate, Abuja</p>
                            <p>info@landnkitchen.com</p>
                    </div>

                    </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.0/js/bootstrap.min.js"></script>

</body>
</html>
<?php /**PATH /home2/landnkitchen/public_html/core/resources/views/emails/receipt.blade.php ENDPATH**/ ?>