<?php

namespace App\Http\Controllers;

use Exception;
use App\Models\Order;
use App\Models\Transaction;
use App\Mail\AdminOrderMail;
use Illuminate\Http\Request;
use App\Mail\ClientOrderMail;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Redirect;
use App\Http\Actions\InitializeTransaction;
use Unicodeveloper\Paystack\Facades\Paystack;

class PaymentController extends Controller
{

    private $data;
    /**
     * Redirect the User to Paystack Payment Page
     * @return Url
     */
    public function redirectToGateway()
    {
        try{
            $this->data = (new InitializeTransaction())->execute();
            return Paystack::getAuthorizationUrl()->redirectNow();
        }catch(\Exception $e) {
            // return Redirect::back()->withMessage(['msg'=>'The paystack token has expired. Please refresh the page and try again.', 'type'=>'error']);
            dd($e);
            return redirect('/notifications.payment_failed');
        }
    }

    /**
     * Obtain Paystack payment information
     * @return void
     */
    public function handleGatewayCallback()
    {
        
        try {
            $paymentDetails = Paystack::getPaymentData();
            if($paymentDetails['status']){
                // Now you have the payment details,
                // you can store the authorization_code in your db to allow for recurrent subscriptions
                // you can then redirect or do whatever you want
                $data = session()->get('data');
                //mails
                Mail::to($data['email'])->send(new ClientOrderMail($data));
                Mail::to('support@landnkitchen.com.ng')->send(New AdminOrderMail($data));
                Mail::to('landnkitchen@gmail.com')->send(New AdminOrderMail($data));
                // return success page
                return redirect()->route('notifications.payment_success');
            }else{
                return redirect()->route('notifications.payment_failed');
            }
        } catch (Exception $e) {
            dd($e);
            return redirect()->route('notifications.payment_failed');

        }

    }

    public function paymentFailed(){
        return view('notifications.payment_failed');
    }


    public function paymentSuccess(){
        return view('notifications.payment_success');
    }
}
