<?php $__env->startSection("title", "Cart"); ?>
<?php $__env->startSection('content'); ?>

<div id="wrapper">

    <section class="yt-bg-player yt-cart">
        <div class="bg-transparent ">
            <!-- Slider content -->
            <div class="container dark slider-content"> <i class="icon-top-draw"></i>
                <div id="text-transform" class="owl-carousel">
                    <div class="item">
                        <h1>Checkout</h1>
                    </div>
                </div>
                <p class="text-capitalize">An Oasis Of Pleasure</p>
                <i class="icon-bottom-draw"></i>
            </div>
            <!-- End Slider content -->
        </div>
        <!-- End Bg transparent -->
    </section>
    <?php echo $__env->make('layouts.includes.main-header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  <div id="content">
    <?php echo $__env->make('layouts.includes.main-nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- My Account
    ============================================= -->
    <section class="myaccount text-left padding-100">
        <div class="container">
            <div class="row">
                <div class="col-md-12 carts-content">
                    <div class="row">
                        <!-- Cart Total -->
                        <div class="col-md-4 carts-total text-left">
                            <?php
                                $total = 0;
                                $subtotal = 0;
                                $vat = 0;
                            ?>
                            <?php if(count($cart) != 0): ?>
                                <?php $__currentLoopData = $cart; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $total += floatval($row['price']) * intval($row['quantity']);
                                        $subtotal += floatval($row['price']) * intval($row['quantity']);
                                        $vat += floatval($row['vat']);
                                    ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                            <?php if(session()->has('deliverycost') && session('type')=='delivery'): ?>
                                <?php $total += session('deliverycost'); ?>
                            <?php endif; ?>

                            <?php if(session('takeaway_fee') && session('type')!='dine_in' && session()->has('type')): ?>
                                <?php $total += session('takeaway_fee'); ?>
                            <?php endif; ?>

                        <h3>Carts Total</h3>
                        <table class="table table-bordered">
                            <tbody>
                            <tr>
                                <td>Cart Subtotal</td>
                            <td>₦ <?php echo e(number_format($subtotal,2)); ?></td>
                            </tr>
                            <tr>
                                <td>Delivery Charges</td>
                                <td><?php if(session('deliverycost') && session('type')=='delivery'): ?> ₦ <?php echo e(number_format(session('deliverycost'),2)); ?> <?php else: ?> N/A <?php endif; ?></td>
                            </tr>
                            <?php if(session('takeaway_fee') && session('type')!='dine_in' && session()->has('type')): ?>
                            <tr>
                                <td>Takeaway Pack Charges</td>
                                <td>
                                    ₦ <?php echo e(number_format(session('takeaway_fee'),2)); ?>

                                <span class="pull-right"> x<?php echo e(session('takeaway_count')); ?></span>
                                </td>
                            </tr>
                            <?php endif; ?>
                            <tr>
                                <td>V.A.T (7.5 %)</td>
                                    <td>₦ <?php echo e(number_format($vat,2)); ?></td>
                                </tr>
                            <tr>
                                <td>Order Total</td>
                                    <?php
                                        session()->put('vat', $vat);
                                        $total += $vat;
                                    ?>
                                    <td>₦ <?php echo e(number_format($total,2)); ?></td>
                                </tr>
                            </tbody>
                        </table>

                        <div class="calc-shipping margin-tb-60">
                            <?php if(!session('type')): ?>
                                <h3>Select Option</h3>
                            <?php else: ?>
                                <h3>Update Option</h3>
                            <?php endif; ?>
                            <div class="form-group">
                            <div class="select_wrap">
                                <select id="type" class="form-control" name="location" required>
                                    <option value="">-- SELECT --</option>
                                    <option value="dine_in">DINE IN</option>
                                    <option value="pick_up">PICK UP</option>
                                    <option value="delivery">DELIVERY</option>
                                </select>
                            </div>
                            </div>
                        </form>
                        </div>

                            <div id="delivery" class="calc-shipping margin-tb-60">
                                <h3>Delivery</h3>
                                <form action="<?php echo e(route('del.checkout')); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="input-group">
                                                <label>Delivery Date</label>
                                                <input type="date" name="delivery_date" id="delivery_date" class="form-control" aria-label="...">
                                            </div><!-- /input-group -->
                                        </div><!-- /.col-lg-6 -->

                                        <div class="col-lg-6">
                                            <div class="input-group">
                                            <label>Delivery Time</label>
                                            <input type="time" name="delivery_time" class="form-control" aria-label="...">
                                            </div><!-- /input-group -->
                                        </div><!-- /.col-lg-6 -->

                                        <div class="col-lg-12">
                                            <div class="input-group">
                                                <input class="form-control" type="hidden" name="type" value="delivery" />
                                                <div class="select_wrap">
                                                    <select class="form-control" name="location" required>
                                                        <option value="one">Select Your Location</option>
                                                        <?php $__currentLoopData = $locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($loc->id); ?>"><?php echo e($loc->location); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- End select wrap -->

                                        <div class="col-lg-12">
                                            <div class="input-group">
                                                <input type="text" class="form-control" name="address" placeholder="Address" size="50" required value="<?php if(Auth::check()): ?> <?php echo e(auth()->user()->address); ?> <?php endif; ?>">
                                            </div>
                                        </div>

                                        <div class="col-lg-12">
                                            <div class="input-group">
                                                <label>Instructions</label>
                                                <textarea name="instructions" class="form-control" cols="35" rows="5"></textarea>
                                            </div><!-- /input-group -->
                                        </div><!-- /.col-lg-6 -->

                                        <div class="col-lg-12">
                                            <div class="input-group">
                                                <br>
                                                <button type="submit" class="btn form-control btn-black">UPDATE</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                            <!-- Carts total -->

                            <div id="dine_in" class="calc-shipping margin-tb-60">
                                <h3>Dine In</h3>
                                <form action="<?php echo e(route('del.checkout')); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="type" value="dine_in" />
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="input-group">
                                                <label>Arrival Date</label>
                                                <input type="date" name="arrival_date" id="arrival_date" class="form-control" aria-label="...">
                                            </div><!-- /input-group -->
                                        </div><!-- /.col-lg-6 -->
                                        <div class="col-lg-6">
                                            <div class="input-group">
                                                <label>Arrival Time</label>
                                                <input type="time" name="arrival_time" class="form-control" aria-label="...">
                                            </div><!-- /input-group -->
                                        </div><!-- /.col-lg-6 -->
                                        <div class="col-lg-12">
                                            <div class="input-group">
                                                <label>Instructions</label>
                                                <textarea name="instructions" class="form-control" cols="35" rows="5"></textarea>
                                            </div><!-- /input-group -->
                                        </div><!-- /.col-lg-6 -->
                                        <div class="col-lg-12">
                                            <br>
                                            <button type="submit" class="btn form-control btn-black">Submit</button>
                                        </div>
                                    </div><!-- /.row -->
                                </form>
                            </div>

                            <div id="pick_up" class="calc-shipping margin-tb-60">
                                <h3>Pick Up</h3>
                                <p>Note:<i> Extra Fee of N250 for takeaway pack applies for each item</i></p>
                                <form action="<?php echo e(route('del.checkout')); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="type" value="pick_up" />
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="input-group">
                                                <label>Pickup Date</label>
                                                <input type="date" name="pickup_date" id="pickup_date" class="form-control" aria-label="...">
                                            </div><!-- /input-group -->
                                        </div><!-- /.col-lg-6 -->
                                        <div class="col-lg-6">
                                            <div class="input-group">
                                                <label>Pickup Time</label>
                                                <input type="time" name="pickup_time" class="form-control" aria-label="...">
                                            </div><!-- /input-group -->
                                        </div><!-- /.col-lg-6 -->
                                        <div class="col-lg-12">
                                            <div class="input-group">
                                                <label>Instructions</label>
                                                <textarea name="instructions" class="form-control" cols="35" rows="5"></textarea>
                                            </div><!-- /input-group -->
                                        </div><!-- /.col-lg-6 -->
                                        <div class="col-lg-12">
                                            <br>
                                            <button type="submit" class="btn form-control btn-black">Submit</button>
                                        </div>
                                    </div><!-- /.row -->
                                </form>
                            </div>
                        </div>
                        <!-- End # Cart Total -->

                        <!-- Billing Details -->
                        <div class="col-md-8">
                            <div class="calc-shipping">
                                <h3>Customer Details <?php if(auth()->guard()->guest()): ?><small>Already have an account? <a href="<?php echo e(route('login')); ?>" class="btn-link">Login</a></small><?php endif; ?></h3>
                                <?php if(!Auth::check()): ?>
                                    <form action="<?php echo e(route('guest-user.store')); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <div class="form-group">
                                            <input type="text" class="form-control <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border border-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> " name="first_name" placeholder="First Name*">
                                            <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><span class="ml-3 text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        <div class="form-group">
                                            <input type="text" class="form-control  <?php $__errorArgs = ['last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border border-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="last_name" placeholder="Last Name*">
                                            <?php $__errorArgs = ['last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><span class="ml-3 text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        <div class="form-group">
                                            <input type="text" class="form-control <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border border-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> " name="address" placeholder="Address*">
                                            <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><span class="ml-3 text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        <div class="form-group">
                                            <input type="text" class="form-control" name="email" placeholder="Email">
                                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><span class="ml-3 text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        <div class="form-group">
                                            <input type="text" class="form-control" name="phone" placeholder="Phone">
                                            <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><span class="ml-3 text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <?php if(session('type')): ?>
                                            <button type="submit" class="btn form-control btn-black">Order Now</button>
                                        <?php else: ?>
                                            <button type="button" class="btn form-control btn-black" disabled>please select option before proceeding</button>
                                        <?php endif; ?>
                                    </form>
                                <?php else: ?>
                                    <div class="form-group">
                                        <input type="text" class="form-control" value="<?php echo e(auth()->user()->first_name.' '.auth()->user()->last_name); ?>" readonly>
                                        <input type="text" class="form-control" value="<?php echo e(auth()->user()->email); ?>" readonly>
                                        <input type="text" class="form-control" value="<?php echo e(auth()->user()->tel); ?>" readonly>
                                        <input type="text" class="form-control" value="<?php echo e(auth()->user()->address); ?>" readonly>
                                    </div>
                                    <?php if(session('type')): ?>
                                        <a href="<?php echo e(route('payment')); ?>" class="btn form-control btn-black">Order Now</a>
                                    <?php else: ?>
                                        <button type="button" class="btn form-control btn-black" disabled>please select option before proceeding</button>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </div>
                        </div>
                        <!-- Billing Details -->
                    </div>
                </div>
            </div>
        </div>
    </section>
      <!-- End myaccount -->
  </div>
  <!-- end of #content -->
</div>

<script src="javascripts/libs/jquery.min.js" type="text/javascript"></script>
<script>

    $("#pick_up").hide();
    $("#dine_in").hide();
    $("#delivery").hide();

    $("#type").change(function() {
        if( $("#type").val() == "pick_up"){
            $("#pick_up").show();
            $("#dine_in").hide();
            $("#delivery").hide();
        }else if($("#type").val() == "dine_in"){
            $("#dine_in").show();
            $("#pick_up").hide();
            $("#delivery").hide();
        }else if($("#type").val() == "delivery"){
            $("#delivery").show();
            $("#pick_up").hide();
            $("#dine_in").hide();
        }else{
            $("#pick_up").hide();
            $("#dine_in").hide();
            $("#delivery").hide();
        }
    });
  $('#delivery_date, #arrival_date, #pick_date').attr('min', new Date().toISOString().split('T')[0])

</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/landnkitchen/public_html/core/resources/views/checkout.blade.php ENDPATH**/ ?>