<?php $__env->startSection("title", "Payments"); ?>
<?php $__env->startSection('content'); ?>

<div id="wrapper">

    <section class="yt-bg-player yt-cart" >
        <div class="bg-transparent ">
            <!-- Slider content -->
            <div class="container dark slider-content"> <i class="icon-top-draw"></i>
                <div id="text-transform" class="owl-carousel">
                <div class="item">
                    <h1>Payment</h1>
                </div>
                </div>
                <p class="text-capitalize">An Oasis Of Pleasure</p>
                <i class="icon-bottom-draw"></i>
            </div>
            <!-- End Slider content -->
        </div>
        <!-- End Bg transparent -->
    </section>
    <?php echo $__env->make('layouts.includes.main-header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  <div id="content">
    <?php echo $__env->make('layouts.includes.main-nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Carts
    ============================================= -->
    <section class="carts text-center padding-100">
        <div class="container">
          <div class="row">
            <div class="col-md-12">

            <!-- Cart Total -->
              <center>
                <div class="col-md-6 col-md-offset-3 carts-total text-left">
                    <?php
                        $total = 0;
                        $paystack_charge = 0;
                    ?>
                    <?php if(count($cart) != 0): ?>
                        <?php $__currentLoopData = $cart; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php $total += $row['price'] * $row['quantity'];?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php if(session()->has('deliverycost') && session('type')=='delivery'): ?>
                            <?php $total += session('deliverycost'); ?>
                        <?php endif; ?>
                        <?php if(session()->has('takeaway_fee') && session('type')!='dine_in' && session()->has('type')): ?>
                            <?php $total += session('takeaway_fee'); ?>
                        <?php endif; ?>
                        <?php
                            $total += session('vat');
                            if($total >= 2000){
                                $paystack_charge = $total * 0.015;
                            }
                            $total_money = $total + $paystack_charge + 100;
                            $paystack_amount = ($total_money * 100);
                        ?>
                    <?php endif; ?>

                    <h3>Order Summary</h3>
                        <?php if(!Auth::check()): ?>
                            <table class="table table-bordered">
                                <?php if(session()->has('user')): ?>
                                    <?php $user = session()->get('user') ?>
                                    <tbody>
                                        <tr>
                                            <td>Full Name</td>
                                            <td><?php echo e($user['first_name'].' '.$user['last_name']); ?></td>
                                        </tr>
                                        <tr>
                                            <td>Email Address</td>
                                            <td><?php echo e($user['email']); ?></td>
                                        </tr>
                                        <tr>
                                            <td>Phone Number</td>
                                            <td><?php echo e($user['phone']); ?></td>
                                        </tr>
                                        <tr>
                                            <td>Address</td>
                                            <td><?php echo e($user['address']); ?></td>
                                        </tr>
                                        <tr>
                                            <td>Delivery Charges</td>
                                            <td>N/A</td>
                                        </tr>
                                        <tr>
                                            <td>V.A.T (7.5%)</td>
                                            <td>₦ <?php echo e(number_format(session('vat'),2)); ?></td>
                                        </tr>
                                        <tr>
                                            <td>Order Total</td>
                                            <td>₦ <?php echo e(number_format($total_money,2)); ?> (Charges Inclusive)</td>
                                        </tr>
                                    </tbody>
                                <?php endif; ?>
                            </table>
                            <?php else: ?>
                                <table class="table table-bordered">
                                    <tbody>
                                        <tr>
                                            <td>Full Name</td>
                                            <td><?php echo e(auth()->user()->first_name.' '.auth()->user()->last_name); ?></td>
                                        </tr>
                                        <tr>
                                            <td>Email Address</td>
                                            <td><?php echo e(auth()->user()->email); ?></td>
                                        </tr>
                                        <tr>
                                            <td>Phone Number</td>
                                            <td><?php echo e(auth()->user()->phone); ?></td>
                                        </tr>
                                        <tr>
                                            <td>Address</td>
                                            <td><?php echo e(session('deliveryaddress')); ?></td>
                                        </tr>
                                        <tr>
                                            <td>Delivery Charges</td>
                                            <td><?php if(session('deliverycost')): ?> ₦<?php echo e(session('deliverycost')); ?> <?php else: ?> N/A <?php endif; ?></td>
                                        </tr>
                                        <tr>
                                            <td>V.A.T (7.5%)</td>
                                            <td>₦ <?php echo e(number_format(session('vat'),2)); ?></td>
                                        </tr>
                                        <tr>
                                            <td>Order Total</td>
                                            <td>₦ <?php echo e(number_format($total_money,2)); ?> (Charges Inclusive)</td>
                                        </tr>
                                    </tbody>
                                </table>
                            <?php endif; ?>
                            <div class="calc-shipping margin-tb-60">
                                <h3>Select Payment Method</h3>
                                <div class="form-group">
                                    <!-- Selct wrap -->
                                    <div class="select_wrap dark_slect">
                                        <select class="form-control">
                                            <option selected value="credit-card">Card Payment</option>
                                            <option value="bank_transfer" disabled>Bank Transfer</option>
                                        </select>
                                    </div>
                                    <!-- End select wrap -->
                                </div>
                            </div>
                            <?php if(Auth::check()): ?>
                                <form method="POST" action="<?php echo e(route('pay')); ?>" accept-charset="UTF-8" class="form-horizontal" role="form">
                                    <div class="row" style="margin-bottom:40px;">
                                        <div class="col-md-8 col-md-offset-2">
                                            <input type="hidden" name="email" value="<?php echo e(auth()->user()->email); ?>"> 
                                            <input type="hidden" name="amount" value="<?php echo e($paystack_amount); ?>">
                                            <input type="hidden" name="quantity" value="1">
                                            <input type="hidden" name="currency" value="NGN">
                                            <input type="hidden" name="metadata" value="<?php echo e(json_encode($array = ['name' => auth()->user()->getFullName(),'cart' => $cart,'user' => auth()->user(),'user_id' => auth()->user()->id])); ?>" > 
                                            <?php
                                                $ref = Paystack::genTranxRef();
                                                session()->put('ref', $ref);
                                                session()->put('paystack_amount', $paystack_amount);
                                            ?>
                                            <input type="hidden" name="reference" value="<?php echo e($ref); ?>"> 
                                            <?php echo csrf_field(); ?>
                                            <p>
                                                <button class="btn btn-black btn-lg btn-block" type="submit" value="Pay Now!">
                                                    <i class="fa fa-plus-circle fa-lg"></i> Pay Now
                                                </button>
                                            </p>
                                        </div>
                                    </div>
                                </form>
                            <?php else: ?>
                            <?php $user = session('user'); ?>
                                <form method="POST" action="<?php echo e(route('pay')); ?>" accept-charset="UTF-8" class="form-horizontal" role="form">
                                    <div class="row" style="margin-bottom:40px;">
                                        <div class="col-md-8 col-md-offset-2">
                                            <input type="hidden" name="email" value="<?php echo e($user['email']); ?>"> 
                                            <input type="hidden" name="amount" value="<?php echo e($paystack_amount); ?>">
                                            <input type="hidden" name="quantity" value="1">
                                            <input type="hidden" name="currency" value="NGN">
                                            <input type="hidden" name="metadata" value="<?php echo e(json_encode($array = ['name' => $user['first_name'].' '.$user['last_name'],'cart' => $cart,'user' => $user,'user_id' => null])); ?>" > 
                                            <?php
                                                $ref = Paystack::genTranxRef();
                                                session()->put('ref', $ref);
                                                session()->put('paystack_amount', $paystack_amount);
                                            ?>
                                            <input type="hidden" name="reference" value="<?php echo e($ref); ?>"> 
                                            <?php echo csrf_field(); ?>
                                            <p>
                                                <button class="btn btn-black btn-lg btn-block" type="submit" value="Pay Now!">
                                                    <i class="fa fa-plus-circle fa-lg"></i> Pay Now
                                                </button>
                                            </p>
                                        </div>
                                    </div>
                                </form>
                            <?php endif; ?>
                <!-- Carts total -->
                </div>
            </center>
            <!-- End # Cart Total -->
            </div>
          </div>
        </div>
      </section>
      <!-- End Carts -->
  </div>
  <!-- end of #content -->
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/landnkitchen/public_html/core/resources/views/payment.blade.php ENDPATH**/ ?>