@extends("layouts.admin")
@section("title", "Add Product")
@section('content')

<div class="container-fluid">
    <!-- Page-Title -->
    <div class="row">
        <div class="col-sm-12">
            <div class="page-title-box">
                <div class="row">
                    <div class="col">
                        <h4 class="page-title">Products</h4>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('home') }}">Landnkitchen</a></li>
                            <li class="breadcrumb-item active">Add Product</li>
                        </ol>
                    </div><!--end col-->
                </div><!--end row-->
            </div><!--end page-title-box-->
        </div><!--end col-->
    </div><!--end row-->
    <!-- end page title end breadcrumb -->

    <div class="row">
        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                @if (Session::has('error'))
                    <div class="alert alert-danger" role="alert">
                        {{ Session::get('error') }}
                    </div>
                @endif
                @if (Session::has('success'))
                    <div class="alert alert-success" role="alert">
                        {{ Session::get('success') }}
                    </div>
                @endif
                    <h4 class="card-title">Add Product</h4>
                </div><!--end card-header-->
                <div class="card-body">
                    <form action="{{ route("add.product") }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="form-material">
                            <div class="form-group">
                                <label class="mb-1" for="name">Name</label>
                                <input type="text" class="form-control @error('name') border border-danger @enderror" id="name" name="name" required value="{{ old("name") }}" required>
                                @error('name')<span class="ml-3 text-danger">{{ $message }}</span> @enderror
                            </div>
                            <div class="form-group">
                                <label class="mb-1" for="category">Category</label>
                                <select class="form-control" required name="category" id="category">
                                    <option value="">--- Select Option ---</option>
                                    @foreach ( $categories as $category)
                                        <option value="{{ $category->id }}">{{ $category->name }}</option>
                                    @endforeach
                                </select>
                                @error('category')<span class="ml-3 text-danger">{{ $message }}</span> @enderror
                            </div>
                            <div class="form-group">
                                <label class="mb-1" for="price">Price</label>
                                <input type="number" class="form-control @error('price') border border-danger @enderror" id="price" name="price" required value="{{ old("price") }}">
                                @error('price')<span class="ml-3 text-danger">{{ $message }}</span> @enderror
                            </div>
                            <div class="form-group">
                                <label class="mb-1" for="price">VAT</label>
                                <input type="number" class="form-control @error('vat') border border-danger @enderror" id="vat" name="vat" value="{{ old("vat") }}">
                                @error('vat')<span class="ml-3 text-danger">{{ $message }}</span> @enderror
                            </div>
                            <div class="form-group">
                                <label class="mb-1" for="image">Image</label>
                                <input type="file" class="form-control @error('file') border border-danger @enderror" id="file" name="file">
                                @error('file')<span class="ml-3 text-danger">{{ $message }}</span> @enderror
                            </div>

                            <div class="form-group">
                                <label class="my-1" for="description">Description</label>
                                <textarea class="form-control @error('description') border border-danger @enderror" id="description" cols="30" rows="2" name="description">{{ old("description") }}</textarea>
                                @error('description')<span class="ml-3 text-danger">{{ $message }}</span> @enderror
                            </div>
                            <button type="submit" class="btn btn-primary mt-3">Submit</button>
                        </div>
                    </form>
                </div><!--end card-body-->
            </div><!--end card-->
        </div> <!-- end col -->
    </div><!--end row-->
</div><!-- container -->

@endsection
