@extends("layouts.admin")
@section("title", "Profile")
@section('content')

<div class="container-fluid">
    <!-- Page-Title -->
    <div class="row">
        <div class="col-sm-12">
            <div class="page-title-box">
                <div class="row">
                    <div class="col">
                        <h4 class="page-title">Profile</h4>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('home') }}">Landnkitchen</a></li>
                            <li class="breadcrumb-item active">Profile</li>
                        </ol>
                    </div><!--end col-->
                </div><!--end row-->
            </div><!--end page-title-box-->
        </div><!--end col-->
    </div><!--end row-->
    <!-- end page title end breadcrumb -->

    <div class="row">
        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                @if (Session::has('error'))
                    <div class="alert alert-danger" role="alert">
                        {{ Session::get('error') }}
                    </div>
                @endif
                @if (Session::has('success'))
                    <div class="alert alert-success" role="alert">
                        {{ Session::get('success') }}
                    </div>
                @endif
                    <h4 class="card-title">Edit Profile</h4>
                </div><!--end card-header-->
                <div class="card-body">
                    <form action="{{ route("update.account") }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="form-material">
                            <div class="form-group">
                                <label class="mb-1" for="name">First Name</label>
                                <input type="text" class="form-control @error('first_name') border border-danger @enderror" id="first_name" name="first_name" required value="{{ Auth()->user()->first_name }}" required>
                                @error('first_name')<span class="ml-3 text-danger">{{ $message }}</span> @enderror
                            </div>
                            <div class="form-group">
                                <label class="mb-1" for="name">Last Name</label>
                                <input type="text" class="form-control @error('last_name') border border-danger @enderror" id="last_name" name="last_name" required value="{{ Auth()->user()->last_name }}" required>
                                @error('last_name')<span class="ml-3 text-danger">{{ $message }}</span> @enderror
                            </div>
                            <div class="form-group">
                                <label class="mb-1" for="name">Telephone</label>
                                <input type="tel" class="form-control @error('tel') border border-danger @enderror" id="tel" name="tel" required value="{{ Auth()->user()->tel }}" required>
                                @error('tel')<span class="ml-3 text-danger">{{ $message }}</span> @enderror
                            </div>
                            <div class="form-group">
                                <label class="mb-1" for="name">Email</label>
                                <input type="email" class="form-control @error('email') border border-danger @enderror" id="email" name="email" required value="{{ Auth()->user()->email }}" readonly required>
                                @error('email')<span class="ml-3 text-danger">{{ $message }}</span> @enderror
                            </div>
                            <div class="form-group">
                                <label class="mb-1" for="name">Address</label>
                                <input type="address" class="form-control @error('address') border border-danger @enderror" id="address" name="address" required value="{{ Auth()->user()->address }}" required>
                                @error('address')<span class="ml-3 text-danger">{{ $message }}</span> @enderror
                            </div>
                            <button type="submit" class="btn btn-primary mt-3">Save Changes</button>
                        </div>
                    </form>
                </div><!--end card-body-->
            </div><!--end card-->
        </div> <!-- end col -->
    </div><!--end row-->

</div><!-- container -->
@endsection
